<style>
#dropZoneMaleLight {
    border: 2px dashed #007BFF;
    padding: 30px;
    text-align: center;
    color: #6C757D;
    cursor: pointer;
}

#dropZoneMaleLight.dragover {
    background-color: #E9F5FF;
}

.preview {
    display: flex;
    flex-wrap: wrap;
    gap: 10px;
}

.preview-item {
    display: flex;
    flex-direction: column;
    align-items: center;
    border: 1px solid #ccc;
    padding: 5px;
    border-radius: 5px;
}

.preview-item img {
    max-width: 100px;
    max-height: 100px;
    margin-bottom: 5px;
}

.preview-item button {
    background-color: #f44336;
    color: white;
    border: none;
    padding: 4px 8px;
    border-radius: 4px;
    cursor: pointer;
}

.preview-item button:hover {
    background-color: #d32f2f;
}

#dropZoneMaleTan {
    border: 2px dashed #007BFF;
    padding: 30px;
    text-align: center;
    color: #6C757D;
    cursor: pointer;
}

#dropZoneMaleTan.dragover {
    background-color: #E9F5FF;
}

#dropZoneMaleDark {
    border: 2px dashed #007BFF;
    padding: 30px;
    text-align: center;
    color: #6C757D;
    cursor: pointer;
}

#dropZoneMaleDark.dragover {
    background-color: #E9F5FF;
}

#dropZoneFemaleLight {
    border: 2px dashed #007BFF;
    padding: 30px;
    text-align: center;
    color: #6C757D;
    cursor: pointer;
}

#dropZoneFemaleLight.dragover {
    background-color: #E9F5FF;
}

#dropZoneFemaleTan {
    border: 2px dashed #007BFF;
    padding: 30px;
    text-align: center;
    color: #6C757D;
    cursor: pointer;
}

#dropZoneFemaleTan.dragover {
    background-color: #E9F5FF;
}

#dropZoneFemaleDark {
    border: 2px dashed #007BFF;
    padding: 30px;
    text-align: center;
    color: #6C757D;
    cursor: pointer;
}

#dropZoneFemaleDark.dragover {
    background-color: #E9F5FF;
}
</style>
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <div class="img-profile ml-3">

                </div>
                <h1 class="m-0 text-dark">Update Images</h1>

            </div><!-- /.col -->
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?= base_url(); ?>dashboard/userimages">User Images</a></li>
                    <li class="breadcrumb-item active">Update Images</li>
                </ol>
            </div><!-- /.col -->
        </div><!-- /.row -->
    </div><!-- /.container-fluid -->
</div>
<!-- <form method="post" id="userImages" class="card" action="<?php echo base_url() . "dashboard/saveimages"?>" enctype="multipart/form-data"> -->
<form id="userImages" class="card" enctype="multipart/form-data">
    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="card-body">

                <div class="row mb-5">
                    <div class="col-12">Newly uploaded images will be replaced with current images</div>

                </div>
                <div class="row">

                    <div class="col-12">
                        <label class="form-label">Male Light<span class="form-required">*</span></label>
                        <div class="form-group">
                            <div id="dropZoneMaleLight" class="mb-3">
                                Drag & drop files here or click to browse
                                <input type="file" id="male_light" name="male_light" multiple hidden />
                            </div>
                            <div id="maleLightList" class="mb-3 preview"></div>
                            <!-- <div id="preview" class="mb-3 list-group"></div> -->
                        </div>
                    </div>
                    <div class="col-12">
                        <label class="form-label">Male Tan<span class="form-required">*</span></label>
                        <div class="form-group">
                            <div id="dropZoneMaleTan" class="mb-3">
                                Drag & drop files here or click to browse
                                <input type="file" id="male_tan" name="male_tan" multiple hidden />
                            </div>
                            <div id="maleTanList" class="mb-3 preview"></div>
                        </div>
                    </div>
                    <div class="col-12">
                        <label class="form-label">Male Dark<span class="form-required">*</span></label>
                        <div class="form-group">
                            <div id="dropZoneMaleDark" class="mb-3">
                                Drag & drop files here or click to browse
                                <input type="file" id="male_dark" name="male_dark" multiple hidden />
                            </div>
                            <div id="maleDarkList" class="mb-3 preview"></div>
                        </div>
                    </div>
                    <div class="col-12">
                        <label class="form-label">Female Light<span class="form-required">*</span></label>
                        <div class="form-group">
                            <div id="dropZoneFemaleLight" class="mb-3">
                                Drag & drop files here or click to browse
                                <input type="file" id="female_light" name="female_light" multiple hidden />
                            </div>
                            <div id="femaleLightList" class="mb-3 preview"></div>
                        </div>
                    </div>
                    <div class="col-12">
                        <label class="form-label">Female Tan<span class="form-required">*</span></label>
                        <div class="form-group">
                            <div id="dropZoneFemaleTan" class="mb-3">
                                Drag & drop files here or click to browse
                                <input type="file" id="female_tan" name="female_tan" multiple hidden />
                            </div>
                            <div id="femaleTanList" class="mb-3 preview"></div>
                        </div>
                    </div>
                    <div class="col-12">
                        <label class="form-label">Female Dark<span class="form-required">*</span></label>
                        <div class="form-group">
                            <div id="dropZoneFemaleDark" class="mb-3">
                                Drag & drop files here or click to browse
                                <input type="file" id="female_dark" name="female_dark" multiple hidden />
                            </div>
                            <div id="femaleDarkList" class="mb-3 preview"></div>
                        </div>
                    </div>

                </div>

            </div>

        </div>
    </section>
    <!-- /.content -->


    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">

            <div class="card-footer text-right">

                <button type="submit" class="btn btn-primary">Update Images</button>
            </div>
        </div>
    </section>
    <!-- /.content -->
</form>
<script>
const dropZoneMaleLight = document.getElementById("dropZoneMaleLight");
const fileInputMaleLight = document.getElementById("male_light");
const maleLightList = document.getElementById("maleLightList");
let selectedFilesMaleLight = [];

function renderMaleLightPreview() {
    maleLightList.innerHTML = '';

    selectedFilesMaleLight.forEach((file, index) => {
        const reader = new FileReader();
        const item = document.createElement('div');
        item.className = 'preview-item';

        reader.onload = (e) => {
            const img = document.createElement('img');
            img.src = e.target.result;
            item.appendChild(img);
        };

        reader.readAsDataURL(file);

        const caption = document.createElement('div');
        caption.textContent = file.name;
        item.appendChild(caption);

        const removeBtn = document.createElement('button');
        removeBtn.textContent = 'Remove';
        removeBtn.onclick = () => {
            selectedFilesMaleLight.splice(index, 1);
            renderMaleLightPreview();
        };

        item.appendChild(removeBtn);
        maleLightList.appendChild(item);
    });
}
// Click to open file dialog
dropZoneMaleLight.addEventListener("click", () => fileInputMaleLight.click());
// Files selected via file input
fileInputMaleLight.addEventListener("change", (e) => {
    const files = Array.from(e.target.files);
    if (files.length >= 5) {
        alert('You can only select up to 5 images.');
        return;
    }
    let error = false;
    files.forEach(file => {
        if (!file.type.startsWith('image/')) {
            error = true;
            alert(`File "${file.name}" is not an image.`);
            return;
        }
    });
    if (error) {
        return;
    }
    selectedFilesMaleLight = files;
    renderMaleLightPreview();
});
// Drag & drop events
dropZoneMaleLight.addEventListener("dragover", (e) => {
    e.preventDefault();
    dropZoneMaleLight.classList.add("dragover");
});
dropZoneMaleLight.addEventListener("dragleave", () => {
    dropZoneMaleLight.classList.remove("dragover");
});
dropZoneMaleLight.addEventListener("drop", (e) => {
    e.preventDefault();

    dropZoneMaleLight.classList.remove("dragover");
    const files = Array.from(e.dataTransfer.files);
    if (files.length >= 5) {
        alert('You can only select up to 5 images.');
        return;
    }

    let error = false;
    files.forEach(file => {
        if (!file.type.startsWith('image/')) {
            error = true;
            alert(`File "${file.name}" is not an image.`);
            return;
        }
    });
    if (error) {
        return;
    }
    // selectedFilesMaleLight = selectedFilesMaleLight.concat(files);
    selectedFilesMaleLight = files;
    renderMaleLightPreview();
});


const dropZoneMaleTan = document.getElementById("dropZoneMaleTan");
const fileInputMaleTan = document.getElementById("male_tan");
const maleTanList = document.getElementById("maleTanList");
let selectedFilesMaleTan = [];

function renderMaleTanPreview() {
    maleTanList.innerHTML = '';

    selectedFilesMaleTan.forEach((file, index) => {
        const reader = new FileReader();
        const item = document.createElement('div');
        item.className = 'preview-item';

        reader.onload = (e) => {
            const img = document.createElement('img');
            img.src = e.target.result;
            item.appendChild(img);
        };

        reader.readAsDataURL(file);

        const caption = document.createElement('div');
        caption.textContent = file.name;
        item.appendChild(caption);

        const removeBtn = document.createElement('button');
        removeBtn.textContent = 'Remove';
        removeBtn.onclick = () => {
            selectedFilesMaleTan.splice(index, 1);
            renderMaleTanPreview();
        };

        item.appendChild(removeBtn);
        maleTanList.appendChild(item);
    });
}
// Click to open file dialog
dropZoneMaleTan.addEventListener("click", () => fileInputMaleTan.click());
// Files selected via file input
fileInputMaleTan.addEventListener("change", (e) => {
    const files = Array.from(e.target.files);
    if (files.length >= 5) {
        alert('You can only select up to 5 images.');
        return;
    }
    let error = false;
    files.forEach(file => {
        if (!file.type.startsWith('image/')) {
            error = true;
            alert(`File "${file.name}" is not an image.`);
            return;
        }
    });
    if (error) {
        return;
    }
    selectedFilesMaleTan = files;
    renderMaleTanPreview();
});
// Drag & drop events
dropZoneMaleTan.addEventListener("dragover", (e) => {
    e.preventDefault();
    dropZoneMaleTan.classList.add("dragover");
});
dropZoneMaleTan.addEventListener("dragleave", () => {
    dropZoneMaleTan.classList.remove("dragover");
});
dropZoneMaleTan.addEventListener("drop", (e) => {
    e.preventDefault();

    dropZoneMaleTan.classList.remove("dragover");
    const files = Array.from(e.dataTransfer.files);
    if (files.length >= 5) {
        alert('You can only select up to 5 images.');
        return;
    }

    let error = false;
    files.forEach(file => {
        if (!file.type.startsWith('image/')) {
            error = true;
            alert(`File "${file.name}" is not an image.`);
            return;
        }
    });
    if (error) {
        return;
    }
    // selectedFilesMaleLight = selectedFilesMaleLight.concat(files);
    selectedFilesMaleTan = files;
    renderMaleTanPreview();
});

const dropZoneMaleDark = document.getElementById("dropZoneMaleDark");
const fileInputMaleDark = document.getElementById("male_dark");
const maleDarkList = document.getElementById("maleDarkList");
let selectedFilesMaleDark = [];

function renderMaleDarkPreview() {
    maleDarkList.innerHTML = '';

    selectedFilesMaleDark.forEach((file, index) => {
        const reader = new FileReader();
        const item = document.createElement('div');
        item.className = 'preview-item';

        reader.onload = (e) => {
            const img = document.createElement('img');
            img.src = e.target.result;
            item.appendChild(img);
        };

        reader.readAsDataURL(file);

        const caption = document.createElement('div');
        caption.textContent = file.name;
        item.appendChild(caption);

        const removeBtn = document.createElement('button');
        removeBtn.textContent = 'Remove';
        removeBtn.onclick = () => {
            selectedFilesMaleDark.splice(index, 1);
            renderMaleDarkPreview();
        };

        item.appendChild(removeBtn);
        maleDarkList.appendChild(item);
    });
}
// Click to open file dialog
dropZoneMaleDark.addEventListener("click", () => fileInputMaleDark.click());
// Files selected via file input
fileInputMaleDark.addEventListener("change", (e) => {
    const files = Array.from(e.target.files);
    if (files.length >= 5) {
        alert('You can only select up to 5 images.');
        return;
    }
    let error = false;
    files.forEach(file => {
        if (!file.type.startsWith('image/')) {
            error = true;
            alert(`File "${file.name}" is not an image.`);
            return;
        }
    });
    if (error) {
        return;
    }
    selectedFilesMaleDark = files;
    renderMaleDarkPreview();
});
// Drag & drop events
dropZoneMaleDark.addEventListener("dragover", (e) => {
    e.preventDefault();
    dropZoneMaleDark.classList.add("dragover");
});
dropZoneMaleDark.addEventListener("dragleave", () => {
    dropZoneMaleDark.classList.remove("dragover");
});
dropZoneMaleDark.addEventListener("drop", (e) => {
    e.preventDefault();

    dropZoneMaleDark.classList.remove("dragover");
    const files = Array.from(e.dataTransfer.files);
    if (files.length >= 5) {
        alert('You can only select up to 5 images.');
        return;
    }

    let error = false;
    files.forEach(file => {
        if (!file.type.startsWith('image/')) {
            error = true;
            alert(`File "${file.name}" is not an image.`);
            return;
        }
    });
    if (error) {
        return;
    }
    // selectedFilesMaleLight = selectedFilesMaleLight.concat(files);
    selectedFilesMaleDark = files;
    renderMaleDarkPreview();
});


const dropZoneFemaleDark = document.getElementById("dropZoneFemaleDark");
const fileInputFemaleDark = document.getElementById("female_dark");
const femaleDarkList = document.getElementById("femaleDarkList");
let selectedFilesFemaleDark = [];

function renderFemaleDarkPreview() {
    femaleDarkList.innerHTML = '';

    selectedFilesFemaleDark.forEach((file, index) => {
        const reader = new FileReader();
        const item = document.createElement('div');
        item.className = 'preview-item';

        reader.onload = (e) => {
            const img = document.createElement('img');
            img.src = e.target.result;
            item.appendChild(img);
        };

        reader.readAsDataURL(file);

        const caption = document.createElement('div');
        caption.textContent = file.name;
        item.appendChild(caption);

        const removeBtn = document.createElement('button');
        removeBtn.textContent = 'Remove';
        removeBtn.onclick = () => {
            selectedFilesFemaleDark.splice(index, 1);
            renderFemaleDarkPreview();
        };

        item.appendChild(removeBtn);
        femaleDarkList.appendChild(item);
    });
}
// Click to open file dialog
dropZoneFemaleDark.addEventListener("click", () => fileInputFemaleDark.click());
// Files selected via file input
fileInputFemaleDark.addEventListener("change", (e) => {
    const files = Array.from(e.target.files);
    if (files.length >= 5) {
        alert('You can only select up to 5 images.');
        return;
    }
    let error = false;
    files.forEach(file => {
        if (!file.type.startsWith('image/')) {
            error = true;
            alert(`File "${file.name}" is not an image.`);
            return;
        }
    });
    if (error) {
        return;
    }
    selectedFilesFemaleDark = files;
    renderFemaleDarkPreview();
});
// Drag & drop events
dropZoneFemaleDark.addEventListener("dragover", (e) => {
    e.preventDefault();
    dropZoneFemaleDark.classList.add("dragover");
});
dropZoneFemaleDark.addEventListener("dragleave", () => {
    dropZoneFemaleDark.classList.remove("dragover");
});
dropZoneFemaleDark.addEventListener("drop", (e) => {
    e.preventDefault();

    dropZoneFemaleDark.classList.remove("dragover");
    const files = Array.from(e.dataTransfer.files);
    if (files.length >= 5) {
        alert('You can only select up to 5 images.');
        return;
    }

    let error = false;
    files.forEach(file => {
        if (!file.type.startsWith('image/')) {
            error = true;
            alert(`File "${file.name}" is not an image.`);
            return;
        }
    });
    if (error) {
        return;
    }
    // selectedFilesMaleLight = selectedFilesMaleLight.concat(files);
    selectedFilesFemaleDark = files;
    renderFemaleDarkPreview();
});


const dropZoneFemaleTan = document.getElementById("dropZoneFemaleTan");
const fileInputFemaleTan = document.getElementById("female_tan");
const femaleTanList = document.getElementById("femaleTanList");
let selectedFilesFemaleTan = [];

function renderFemaleTanPreview() {
    femaleTanList.innerHTML = '';

    selectedFilesFemaleTan.forEach((file, index) => {
        const reader = new FileReader();
        const item = document.createElement('div');
        item.className = 'preview-item';

        reader.onload = (e) => {
            const img = document.createElement('img');
            img.src = e.target.result;
            item.appendChild(img);
        };

        reader.readAsDataURL(file);

        const caption = document.createElement('div');
        caption.textContent = file.name;
        item.appendChild(caption);

        const removeBtn = document.createElement('button');
        removeBtn.textContent = 'Remove';
        removeBtn.onclick = () => {
            selectedFilesFemaleTan.splice(index, 1);
            renderFemaleTanPreview();
        };

        item.appendChild(removeBtn);
        femaleTanList.appendChild(item);
    });
}
// Click to open file dialog
dropZoneFemaleTan.addEventListener("click", () => fileInputFemaleTan.click());
// Files selected via file input
fileInputFemaleTan.addEventListener("change", (e) => {
    const files = Array.from(e.target.files);
    if (files.length >= 5) {
        alert('You can only select up to 5 images.');
        return;
    }
    let error = false;
    files.forEach(file => {
        if (!file.type.startsWith('image/')) {
            error = true;
            alert(`File "${file.name}" is not an image.`);
            return;
        }
    });
    if (error) {
        return;
    }
    selectedFilesFemaleTan = files;
    renderFemaleTanPreview();
});
// Drag & drop events
dropZoneFemaleTan.addEventListener("dragover", (e) => {
    e.preventDefault();
    dropZoneFemaleTan.classList.add("dragover");
});
dropZoneFemaleTan.addEventListener("dragleave", () => {
    dropZoneFemaleTan.classList.remove("dragover");
});
dropZoneFemaleTan.addEventListener("drop", (e) => {
    e.preventDefault();

    dropZoneFemaleTan.classList.remove("dragover");
    const files = Array.from(e.dataTransfer.files);
    if (files.length >= 5) {
        alert('You can only select up to 5 images.');
        return;
    }

    let error = false;
    files.forEach(file => {
        if (!file.type.startsWith('image/')) {
            error = true;
            alert(`File "${file.name}" is not an image.`);
            return;
        }
    });
    if (error) {
        return;
    }
    // selectedFilesMaleLight = selectedFilesMaleLight.concat(files);
    selectedFilesFemaleTan = files;
    renderFemaleTanPreview();
});


const dropZoneFemaleLight = document.getElementById("dropZoneFemaleLight");
const fileInputFemaleLight = document.getElementById("female_light");
const femaleLightList = document.getElementById("femaleLightList");
let selectedFilesFemaleLight = [];

function renderFemaleLightPreview() {
    femaleLightList.innerHTML = '';

    selectedFilesFemaleLight.forEach((file, index) => {
        const reader = new FileReader();
        const item = document.createElement('div');
        item.className = 'preview-item';

        reader.onload = (e) => {
            const img = document.createElement('img');
            img.src = e.target.result;
            item.appendChild(img);
        };

        reader.readAsDataURL(file);

        const caption = document.createElement('div');
        caption.textContent = file.name;
        item.appendChild(caption);

        const removeBtn = document.createElement('button');
        removeBtn.textContent = 'Remove';
        removeBtn.onclick = () => {
            selectedFilesFemaleLight.splice(index, 1);
            renderFemaleLightPreview();
        };

        item.appendChild(removeBtn);
        femaleLightList.appendChild(item);
    });
}
// Click to open file dialog
dropZoneFemaleLight.addEventListener("click", () => fileInputFemaleLight.click());
// Files selected via file input
fileInputFemaleLight.addEventListener("change", (e) => {
    const files = Array.from(e.target.files);
    if (files.length >= 5) {
        alert('You can only select up to 5 images.');
        return;
    }
    let error = false;
    files.forEach(file => {
        if (!file.type.startsWith('image/')) {
            error = true;
            alert(`File "${file.name}" is not an image.`);
            return;
        }
    });
    if (error) {
        return;
    }
    selectedFilesFemaleLight = files;
    renderFemaleLightPreview();
});
// Drag & drop events
dropZoneFemaleLight.addEventListener("dragover", (e) => {
    e.preventDefault();
    dropZoneFemaleLight.classList.add("dragover");
});
dropZoneFemaleLight.addEventListener("dragleave", () => {
    dropZoneFemaleLight.classList.remove("dragover");
});
dropZoneFemaleLight.addEventListener("drop", (e) => {
    e.preventDefault();

    dropZoneFemaleLight.classList.remove("dragover");
    const files = Array.from(e.dataTransfer.files);
    if (files.length >= 5) {
        alert('You can only select up to 5 images.');
        return;
    }

    let error = false;
    files.forEach(file => {
        if (!file.type.startsWith('image/')) {
            error = true;
            alert(`File "${file.name}" is not an image.`);
            return;
        }
    });
    if (error) {
        return;
    }
    // selectedFilesMaleLight = selectedFilesMaleLight.concat(files);
    selectedFilesFemaleLight = files;
    renderFemaleLightPreview();
});

// Form submit
document
    .getElementById("userImages")
    .addEventListener("submit", function(e) {
        e.preventDefault();
        let selectedFiles = [];
        selectedFiles['male_light'] = [...selectedFilesMaleLight];
        selectedFiles['male_tan'] = [...selectedFilesMaleTan];
        selectedFiles['male_dark'] = [...selectedFilesMaleDark];
        selectedFiles['female_light'] = [...selectedFilesFemaleLight];
        selectedFiles['female_tan'] = [...selectedFilesFemaleTan];
        selectedFiles['female_dark'] = [...selectedFilesFemaleDark];

        if (
            selectedFiles.length['male_light'] === 0 ||
            selectedFiles.length['male_tan'] === 0 ||
            selectedFiles.length['male_dark'] === 0 ||
            selectedFiles.length['female_light'] === 0 ||
            selectedFiles.length['female_tan'] === 0 ||
            selectedFiles.length['female_dark'] === 0

        ) {
            alert("Please select or drop at least one file.");
            return;
        }
        const formData = new FormData();
        selectedFiles['male_light'].forEach((file, index) => {
            formData.append("male_light[]", file);
        });
        selectedFiles['male_tan'].forEach((file, index) => {
            formData.append("male_tan[]", file);
        });
        selectedFiles['male_dark'].forEach((file, index) => {
            formData.append("male_dark[]", file);
        });
        selectedFiles['female_light'].forEach((file, index) => {
            formData.append("female_light[]", file);
        });
        selectedFiles['female_tan'].forEach((file, index) => {
            formData.append("female_tan[]", file);
        });
        selectedFiles['female_dark'].forEach((file, index) => {
            formData.append("female_dark[]", file);
        });


        fetch('<?=base_url('dashboard/saveimages')?>', {
                method: 'POST',
                body: formData
            }).then(res => res.json())
            .then(data => console.log('Uploaded:', data))
            .catch(err => console.error('Error:', err));
    });
$("#frmMachine").on('submit', function() {
    $("body").addClass("loading");
});
</script>